
<?php $__env->startSection('content'); ?>
    <div id="main">
        <header class="mb-3">
            <a href="#" class="burger-btn d-block d-xl-none">
                <i class="bi bi-justify fs-3"></i>
            </a>
        </header>

        <div class="page-heading">
            <div class="page-title">
                <div class="row">
                    <div class="col-12 col-md-6 order-md-1 order-last">
                        <h3>Payments</h3>
                        <p class="text-subtitle text-muted"></p>
                    </div>
                    <div class="col-12 col-md-6 order-md-2 order-first">
                        <nav aria-label="breadcrumb" class="breadcrumb-header float-start float-lg-end">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="<?php echo e(url('dashboard')); ?>">Dashboard</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Payments</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
             <?php if(session('success')): ?>
                <div class="alert alert-success"><i class="bi bi-check-circle"></i> <?php echo e(session('success')); ?></div>
            <?php endif; ?>
            <?php if(session('error')): ?>
                <div class="alert alert-danger"><i class="bi bi-exclamation-triangle"></i>
                    <?php echo e(session('error')); ?>

                </div>
            <?php endif; ?>
            <section class="section">
                <div class="card">
                    <div class="card-header">
                        All Payments
                        <?php if(Auth::user()->role == 1): ?>
                        <a href="<?php echo e(url('payments/new')); ?>" class="btn btn-primary pull-right"><i class="fa fa-plus" aria-hidden="true"></i>
                            New Payment</a>
                            <?php endif; ?>
                    </div>
                    <div class="card-body">
                        <table class="table table-striped" id="table1">
                            <thead>
                            <tr>
                                 <?php if(Auth::user()->role ==1 ): ?>
                                <th>Customer</th>
                                <th>Phone</th>
                                <?php endif; ?>
                                <th>Receipt Number</th>
                                <th>Amount</th>
                                <th>Status</th>
                                <th>Payment Date</th>
                                  <?php if(Auth::user()->role ==1 ): ?>
                                <th>Actions</th>
                                <?php endif; ?>
                            </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pay): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <?php
                                $p = App\Models\User::where('phone', $pay->phone)->first();

                                ?>
                                <?php if(Auth::user()->role ==1 ): ?>
                                <td><?php echo e($p->name); ?></td>
                                <td><?php echo e($pay->phone); ?></td>
                                <?php endif; ?>
                                <td><?php echo e($pay->receipt_number); ?></td>
                                <td>Khs <?php echo e($pay->amount); ?></td>
                                <?php if($pay->trashed()): ?>
                                <td>
                                    <span class="badge bg-danger">Voided</span>
                                </td>
                                <?php else: ?>
                                 <td>
                                    <span class="badge bg-success">Processed</span>
                                </td>
                                <?php endif; ?>
                                <?php
                                    $inputDateTime = $pay->created_at;
                                $datep = Illuminate\Support\Carbon::parse($inputDateTime);
                                $days_ = $datep->longAbsoluteDiffForHumans(Illuminate\Support\Carbon::now());
                                $daysAgo = $days_;

                                ?>
                                <td><?php echo e($daysAgo); ?></td>
                                  <?php if(Auth::user()->role ==1 ): ?>

                                <td>
                                    <div class="btn-group mb-1">
                                        <div class="dropdown">
                                            <button class="btn btn-secondary btn-sm dropdown-toggle me-1" type="button"
                                                    id="dropdownMenuButtonSec" data-bs-toggle="dropdown"
                                                    aria-haspopup="true" aria-expanded="false">
                                                Actions
                                            </button>
                                            <div class="dropdown-menu" style="min-width:10px !important;" aria-labelledby="dropdownMenuButtonSec">

                                                <a class="dropdown-item" href="<?php echo e(url('payment/void',$pay->id)); ?>"><i class="fa fa-trash" aria-hidden="true" style="color: #7c8db5;"></i> Void</a>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                                <?php endif; ?>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>
                    </div>
                </div>

            </section>
        </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\swiftnet\resources\views/admin/payments/index.blade.php ENDPATH**/ ?>