
<?php $__env->startSection('content'); ?>
    <div id="main">
        <header class="mb-3">
            <a href="#" class="burger-btn d-block d-xl-none">
                <i class="bi bi-justify fs-3"></i>
            </a>
        </header>

        <div class="page-heading">
            <div class="page-title">
                <div class="row">
                    <div class="col-12 col-md-6 order-md-1 order-last">
                        <h3>Expenses</h3>
                        <p class="text-subtitle text-muted"></p>
                    </div>
                    <div class="col-12 col-md-6 order-md-2 order-first">
                        <nav aria-label="breadcrumb" class="breadcrumb-header float-start float-lg-end">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="<?php echo e(url('dashboard')); ?>">Dashboard</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Expenses</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
           <?php if(session('success')): ?>
                <div class="alert alert-success"><i class="bi bi-check-circle"></i> <?php echo e(session('success')); ?></div>
            <?php endif; ?>
            <?php if(session('error')): ?>
                <div class="alert alert-danger"><i class="bi bi-exclamation-triangle"></i>
                    <?php echo e(session('error')); ?>

                </div>
            <?php endif; ?>
            <section class="section">
                <div class="card">
                    <div class="card-header">
                       All Expenses
                       <a href="<?php echo e(url('admin/expense/create')); ?>" class="btn btn-primary pull-right"><i class="fa fa-plus" aria-hidden="true"></i>
                            New Expense</a>
                    </div>

                    <div class="card-body">
                         <table class="table table-striped" id="table1">
                <thead>
                  <tr>
                    <th>#</th>
                    <th>Amount</th>
                    <th>Date</th>
                     <th>Description</th>
                      <th>Added By</th>
                      <?php if(Auth::user()->role == 1): ?>
                    <th>Actions</th>
                    <?php endif; ?>
                   
                  </tr>
                </thead>
                <tbody>
                  <?php $__currentLoopData = $expenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expense): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <tr>
                    <th scope="row"><?php echo e($loop->iteration); ?></th>
                    <td><?php echo e(number_format($expense->amount,2)); ?> Ksh</td>
                   <td><?php echo e($expense->date); ?></td>
                   <td><?php echo e($expense->description); ?></td>
                   <?php
                   $user = App\Models\User::where('id', $expense->user_id)->first();

                   ?>
                    <td><?php echo e($user->name); ?></td>

                   
                  <?php if(Auth::user()->role == 1): ?>
                    


                      <td>
                                    <div class="btn-group mb-1">
                                        <div class="dropdown">
                                            <button class="btn btn-secondary btn-sm dropdown-toggle me-1" type="button"
                                                    id="dropdownMenuButtonSec" data-bs-toggle="dropdown"
                                                    aria-haspopup="true" aria-expanded="false">
                                                Actions
                                            </button>
                                            <div class="dropdown-menu" style="min-width:10px !important;" aria-labelledby="dropdownMenuButtonSec">

                                                    <a class="dropdown-item" href="<?php echo e(url('admin/expense/edit',$expense->id)); ?>"><i class="fa fa-pencil-square-o" aria-hidden="true" style="color: #7c8db5;"></i>
                                                         Edit</a>
                                                          <a class="dropdown-item" href="<?php echo e(url('admin/expense/delete',$expense->id)); ?>"><i class="fa fa-trash" aria-hidden="true" style="color: #7c8db5;"></i>
                                                         Delete</a>
                                                
                                            </div>
                                        </div>
                                    </div>
                                </td>
                      
                         
                    <?php endif; ?>
                  </tr>


                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                
                </tbody>
              </table>
                    </div>
                </div>

            </section>
        </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\swiftnet\resources\views/admin/expenses/index.blade.php ENDPATH**/ ?>