@extends('layouts.app')
@section('content')
    <div id="main">
        <header class="mb-3">
            <a href="#" class="burger-btn d-block d-xl-none">
                <i class="bi bi-justify fs-3"></i>
            </a>
        </header>

        <div class="page-heading">
            <div class="page-title">
                <div class="row">
                    <div class="col-12 col-md-6 order-md-1 order-last">
                        <h3>Users</h3>
                        <p class="text-subtitle text-muted"></p>
                    </div>
                    <div class="col-12 col-md-6 order-md-2 order-first">
                        <nav aria-label="breadcrumb" class="breadcrumb-header float-start float-lg-end">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{url('dashboard')}}">Dashboard</a></li>
                                <li class="breadcrumb-item active" aria-current="page">PPoe Users</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
            @if(session('success'))
                <div class="alert alert-success"><i class="bi bi-check-circle"></i> {{ session('success') }}</div>
            @endif
            @if(session('error'))
                <div class="alert alert-danger"><i class="bi bi-check-circle"></i>
                    {{ session('error') }}
                </div>
            @endif
            <section class="section">
                <div class="card">
                    <div class="card-header">
                        PPoe Users


                        <a href="{{url('/admin/ppoe/user/create')}}" class="btn btn-primary pull-right"><i class="fa fa-plus" aria-hidden="true"></i>
                            New PPoe User</a>

                    </div>

                    <div class="card-body">
                        <table class="table table-striped" id="table1">
                            <thead>
                            <tr>
                                <th>Name</th>
                                <th>Email</th>
                                <th>Phone</th>
                                 <th>Location</th>
                                <th>Package</th>
                                <th>Status</th>

                                <th>Created At</th>

                                <th>Actions</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($users as $user)



                                <tr>
                                    <td>{{$user->name}}</td>
                                    <td>{{$user->email}}</td>
                                    <td>{{$user->phone}}</td>
                                     <td>{{$user->location}}</td>
                                    @php
                                        if($user->role != 1){
                                        $sub = App\Models\Subscription::where('username',$user->phone)->where('status',1)->first();
                                         }else{
                                         $sub = '';
                                     }
                                        $admin = App\Models\User::where('role',1)->first();
                                        if($sub){
                                              $pac = App\Models\Package::where('id',$sub->package)->first();


                                              if($pac)
                                              {
                                                 $package = $pac->name;
                                             }else{
                                             $package = "Not Subscribed";
                                         }
                                             
                                             // $type = $pac->type;

                                        }else{
                                            $package = 'Not Subscribed';
                                        }


                                    @endphp
                                    <td>{{$package}}</td>
                                    <td>
                                        @if($user->role == 1)
                                            <span class="badge bg-success">Active</span>
                                        @elseif($user->role != 1)
                                            @if($sub)
                                                @if($sub->status == 1)

                                                    <span class="badge bg-success">Active</span>
                                                @else
                                                    <span class="badge bg-danger">Inactive</span>
                                                @endif
                                            @else
                                                <span class="badge bg-danger">Inactive</span>
                                            @endif

                                        @endif
                                    </td>
                                    @php
                                        $inputDateTime = $user->created_at;
                                    $datep = Illuminate\Support\Carbon::parse($inputDateTime);
                                    $days_ = $datep->longAbsoluteDiffForHumans(Illuminate\Support\Carbon::now());
                                    $daysAgo = $days_;

                                    @endphp
                                    <td>{{$daysAgo}}</td>
                                    @if($user->role == 2)
                                        <td>
                                            <div class="btn-group mb-1">
                                                <div class="dropdown">
                                                    <button class="btn btn-secondary btn-sm dropdown-toggle me-1" type="button"
                                                            id="dropdownMenuButtonSec" data-bs-toggle="dropdown"
                                                            aria-haspopup="true" aria-expanded="false">
                                                        Actions
                                                    </button>
                                                    <div class="dropdown-menu" style="min-width:10px !important;" aria-labelledby="dropdownMenuButtonSec">

                                                            <a class="dropdown-item" href="{{url('admin/ppoe/user/edit',$user->id)}}"><i class="fa fa-pencil-square-o" aria-hidden="true" style="color: #7c8db5;"></i>
                                                                Edit</a>


                                                        <a class="dropdown-item" href="{{url('user/view',$user->id)}}"><i class="fa fa-eye" aria-hidden="true" style="color: #7c8db5;"></i>
                                                            View</a>
                                                        <a class="dropdown-item" href="{{url('/admin/ppoe/user/delete',$user->id)}}"><i class="fa fa-trash" aria-hidden="true" style="color: #7c8db5;"></i> Delete</a>
                                                       
                                                            @if($sub)
                                                            <a class="dropdown-item" href="{{url('admin/ppoe/user/deactivate',$user->id)}}"><i class="fa fa-ban" aria-hidden="true" style="color: red;"></i>
                                                                        Deactivate</a>
                                                                        @else
                                                        <a class="dropdown-item" href="{{url('admin/ppoe/user/activate',$user->id)}}"><i class="fa fa-reply" aria-hidden="true" style="color: #7c8db5;"></i>
                                                            Activate</a>
                                                                
                                                                @endif
                                                          

                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                    @else
                                        <td>
                                            Admin
                                        </td>
                                    @endif
                                </tr>

                            @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>

            </section>
        </div>

@endsection
