@extends('layouts.app')
@section('content')

<link rel="stylesheet" type="text/css" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
<link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datetimepicker/4.17.47/css/bootstrap-datetimepicker.css">

<style type="text/css">
.center {
  margin: 50px auto 0 auto;
  display: block;
  float: none;
}
.icon-up {
  background-image: url('data:image/svg+xml,<svg viewBox="0 0 256 256" width="50" height="50" xmlns="http://www.w3.org/2000/svg"><path d="M217.6 179.2c-1.637 0-3.274-.625-4.524-1.875L128 92.25l-85.075 85.075c-2.5 2.5-6.55 2.5-9.05 0s-2.5-6.55 0-9.05l89.6-89.6c2.5-2.5 6.55-2.5 9.05 0l89.6 89.6c2.5 2.5 2.5 6.55 0 9.05-1.25 1.25-2.888 1.875-4.525 1.875z" fill="currentColor"/></svg>');
}
.icon-down {
  background-image: url('data:image/svg+xml,<svg viewBox="0 0 256 256" width="50" height="50" xmlns="http://www.w3.org/2000/svg"><path d="M217.6 179.2c-1.637 0-3.274-.625-4.524-1.875L128 92.25l-85.075 85.075c-2.5 2.5-6.55 2.5-9.05 0s-2.5-6.55 0-9.05l89.6-89.6c2.5-2.5 6.55-2.5 9.05 0l89.6 89.6c2.5 2.5 2.5 6.55 0 9.05-1.25 1.25-2.888 1.875-4.525 1.875z" fill="currentColor"/></svg>');
  transform: rotate(180deg);
}
</style>
    <div id="main">
        <header class="mb-3">
            <a href="#" class="burger-btn d-block d-xl-none">
                <i class="bi bi-justify fs-3"></i>
            </a>
        </header>

        <div class="page-heading">
            <div class="page-title">
                <div class="row">
                    <div class="col-12 col-md-6 order-md-1 order-last">
                        <h3>Edit User</h3>
                        <p class="text-subtitle text-muted"></p>
                    </div>
                    <div class="col-12 col-md-6 order-md-2 order-first">
                        <nav aria-label="breadcrumb" class="breadcrumb-header float-start float-lg-end">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{url('dashboard')}}">Dashboard</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Edit User</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
        @if(session('success'))
            <div class="alert alert-success"><i class="bi bi-check-circle"></i> {{ session('success') }}</div>
        @endif
        @if(session('error'))
            <div class="alert alert-danger"><i class="bi bi-check-circle"></i>
                {{ session('error') }}
            </div>
        @endif
        <section id="multiple-column-form">
            <div class="row match-height">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Edit User</h4>
                            <a onclick="history.back()" class="btn btn-primary pull-right"><i class="fa fa-arrow-left" aria-hidden="true"></i>
                                Back</a>
                        </div>
                        <div class="card-content">
                            <div class="card-body">
                                <form class="form" action="{{url('admin/ppoe/user/update',$user->id)}}" method="POST">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="first-name-column">Username</label>
                                                <input type="text" id="first-name-column" class="form-control @error('name') is-invalid @enderror"
                                                       placeholder="Username" name="name" value="{{ $user->name  }}">
                                                @error('name')
                                                <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="last-name-column">Email</label>
                                                <input type="text" id="last-name-column" class="form-control @error('email') is-invalid @enderror"
                                                       placeholder="Email" name="email" value="{{ $user->email }}">
                                                @error('email')
                                                <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="city-column">Phone</label>
                                                <input type="text" id="city-column" class="form-control @error('phone') is-invalid @enderror"
                                                       placeholder="Phone" name="phone" value="{{ $user->phone }}">
                                                @error('phone')
                                                <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                       <!--  <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="country-floating">Password</label>
                                                @php
                                                    $sb = App\Models\Subscription::where('user_id',$user->id)->first();
                                                    $pp = App\Models\Package::where('id',$sb->package)->first();
                                                @endphp

                                                <input type="password" id="country-floating" class="form-control @error('password') is-invalid @enderror"
                                                       name="password" placeholder="Password" value="{{ $sb->password}}">
                                                @error('password')
                                                <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                                @enderror
                                            </div>
                                        </div> -->
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="company-column">Package</label>
                                                <select class="choices form-select @error('package') is-invalid @enderror" name="package">
                                                    <option value="">Select Package</option>
                                                    @php
                                                        $packages = App\Models\Package::all();
                                                    @endphp
                                                    @foreach($packages as $package)
                                                        <option value="{{$package->name}}" @if($package->name == $pp->name) selected @endif>{{$package->name}}</option>
                                                    @endforeach

                                                </select>
                                                @error('package')
                                                <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                          <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="city-column">Location</label>
                                                <input type="text" id="city-column" class="form-control @error('location') is-invalid @enderror"
                                                       placeholder="Location" name="location" value="{{ $user->location }}">
                                                @error('location')
                                                <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                         <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="company-column">Region</label>
                                                <select class="choices form-select @error('region') is-invalid @enderror" name="region">
                                                    <option value="">Select Region</option>
                                                    @php
                                                        $regions = App\Models\Region::orderBy('name','ASC')->get();
                                                        $r = App\Models\Region::where('id',$user->region)->first();
                                                    @endphp
                                                    @foreach($regions as $region)
                                                        <option value="{{$region->id}}" @if($region->name == '') selected @endif >{{$region->name}}</option>
                                                    @endforeach

                                                </select>
                                                @error('region')
                                                <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                                @enderror
                                            </div>
                                        </div>

                                        @php

                                         $dateTime = \Carbon\Carbon::parse($sb->start_date);

                                            // Format only the time part
                                            $formattedDateTime = $dateTime->format('d/m/Y H:i');

                                        @endphp


                                       <div class="col-md-6 col-12" style="">
                                            <div class="form-group">
                                                <label for="country-floating">Start Date format(2023-05-05)</label>
                                               <input type="text" id="country-floating" class="form-control  @error('start_date') is-invalid @enderror js-datetimepicker"
                                                       name="start_date" placeholder="" value="{{$formattedDateTime}}">
                                                @error('start_date')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                            </div>
                                        </div>


                                        <div class="col-12 d-flex justify-content-end">
                                            <button type="submit"
                                                    class="btn btn-primary me-1 mb-1">Submit</button>
                                            <button type="reset"
                                                    class="btn btn-light-secondary me-1 mb-1">Reset</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script type="text/javascript">
        $( ()=> {
  $('.js-datetimepicker').datetimepicker();
});

$( ()=> {
  $('.js-datetimepicker2').datetimepicker({
    icons: {
         time: "fa fa-clock-o",
         date: "fa fa-calendar",
         up:   "icon-up",
         down: "icon-down"
    }
  });
});
    </script>
@endsection
