@extends('layouts.app')
@section('content')
    <div id="main">
        <header class="mb-3">
            <a href="#" class="burger-btn d-block d-xl-none">
                <i class="bi bi-justify fs-3"></i>
            </a>
        </header>

        <div class="page-heading">
            <div class="page-title">
                <div class="row">
                    <div class="col-12 col-md-6 order-md-1 order-last">
                        <h3>This Week Expenses Report</h3>
                        <p class="text-subtitle text-muted"></p>
                    </div>
                    <div class="col-12 col-md-6 order-md-2 order-first">
                        <nav aria-label="breadcrumb" class="breadcrumb-header float-start float-lg-end">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{url('dashboard')}}">Dashboard</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Weekly Expenses Report</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
           @if(session('success'))
                <div class="alert alert-success"><i class="bi bi-check-circle"></i> {{ session('success') }}</div>
            @endif
            @if(session('error'))
                <div class="alert alert-danger"><i class="bi bi-exclamation-triangle"></i>
                    {{ session('error') }}
                </div>
            @endif
            <section class="section">
                <div class="card">
                    <div class="card-header">
                       Weekly Expenses Report
                       
                    </div>

                    <div class="card-body">
                         <table class="table table-bordered" id="table1">
                 <thead>
                  <tr>
                    <th>#</th>
                    <th>Amount</th>
                    <th>Date</th>
                     <th>Description</th>
                      <th>Added By</th>
                   
                   
                  </tr>
                </thead>
                <tbody>
                  @foreach($expenses as $expense)
                  <tr>
                    <th scope="row">{{ $loop->iteration }}</th>
                    <td>{{number_format($expense->amount, 2)}} Ksh</td>
                   <td>{{$expense->date}}</td>
                   <td>{{$expense->description}}</td>
                   @php
                   $user = App\Models\User::where('id', $expense->user_id)->first();

                   @endphp
                    <td>{{$user->name}}</td>

                   
                  
                  </tr>


                  @endforeach
                
                </tbody>
                <tr>
                    <td  style=" border-bottom-style: hidden;
                 
                    border-right-style: hidden;
                    border-left-style: hidden;">
                      
                    </td>
                     <td style=" border-bottom-style: hidden;
                    
                    border-right-style: hidden;
                    border-left-style: hidden;"></td>
                      
                       
                    <td style=" border-bottom-style: hidden;
                
                    border-left-style: hidden;"></td>
                    <td style=" border-bottom-style: hidden;
                
                    border-left-style: hidden; border-top-style: hidden; display: none">SalesSalesSalesSalesSalesSalesSal</td>

                          <td style="background-color: #435ebe; color: #fff;">Total Expenses</td>
                  
                       <td style="background-color: #435ebe; color: #fff;">{{number_format($total,2)}} Ksh</td>
                  </tr>
              </table>
                    </div>
                </div>

            </section>
        </div>

@endsection
