@extends('layouts.app')
@section('content')
    <div id="main">
        <header class="mb-3">
            <a href="#" class="burger-btn d-block d-xl-none">
                <i class="bi bi-justify fs-3"></i>
            </a>
        </header>
        @if(session('success'))
            <div class="alert alert-success"><i class="bi bi-check-circle"></i> {{ session('success') }}</div>
        @endif
        @if(session('error'))
            <div class="alert alert-danger"><i class="bi bi-check-circle"></i>
                {{ session('error') }}
            </div>
        @endif

        <div class="page-heading">
            <div class="page-title">
                <div class="row">
                    <div class="col-12 col-md-6 order-md-1 order-last">
                        <h3>Edit Package</h3>
                        <p class="text-subtitle text-muted"></p>
                    </div>
                    <div class="col-12 col-md-6 order-md-2 order-first">
                        <nav aria-label="breadcrumb" class="breadcrumb-header float-start float-lg-end">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{url('dashboard')}}">Dashboard</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Edit Package</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>



        </div>
        <section id="multiple-column-form">
            <div class="row match-height">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Edit Package</h4>
                            <a onclick="history.back()" class="btn btn-primary pull-right"><i class="fa fa-arrow-left" aria-hidden="true"></i>
                                Back</a>
                        </div>
                        <div class="card-content">
                            <div class="card-body">
                                <form class="form" method="POST" action="{{url('admin/ppoe/update',$package->id)}}">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="first-name-column">Package Name</label>
                                                <input type="text" id="first-name-column" class="form-control  @error('name') is-invalid @enderror"
                                                       placeholder="Package Name" name="name" value="{{ $package->name }}">
                                                @error('name')
                                                <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="last-name-column">Type Of Package</label>
                                                <select class="choices form-select  @error('type') is-invalid @enderror" name="type">
                                                  
                                                    <option value="ppoe">PPOE</option>
                                                </select>
                                                @error('type')
                                                <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="country-floating">Rate Limit</label>
                                                <input type="text" id="country-floating" class="form-control  @error('rate_limit') is-invalid @enderror"
                                                       name="rate_limit" placeholder="Rate Limit" value="{{$package->rate_limit}}">
                                                @error('rate_limit')
                                                <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="city-column">Price </label>
                                                <input type="number" id="city-column" class="form-control  @error('price') is-invalid @enderror"
                                                       placeholder="Enter Price" name="price" value="{{ $package->price }}">
                                                @error('price')
                                                <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                                @enderror
                                            </div>
                                        </div>

                                       
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="country-floating">Local Address</label>
                                                <input type="text" id="country-floating" class="form-control  @error('local_address') is-invalid @enderror"
                                                       name="local_address" placeholder="Local Address" value="{{ $package->local_address }}">
                                                @error('local_address')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="country-floating">Remote Address</label>
                                                <select class="choices form-select @error('remote_address') is-invalid @enderror" name="remote_address">
                                                    <option value="">Select Ip Pool</option>
                                                   
                                                    @foreach($ipPools as $pool)
                                                        <option value="{{$pool['name']}}" @if($pool['name'] == $package->remote_address) selected @endif>{{$pool['name']}}</option>
                                                    @endforeach

                                                </select>
                                                @error('remote_address')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                                @enderror
                                            </div>
                                        </div>
                                        


                                        <div class="col-12 d-flex justify-content-end">
                                            <button type="submit"
                                                    class="btn btn-primary me-1 mb-1">Submit</button>
                                            <button type="reset"
                                                    class="btn btn-light-secondary me-1 mb-1">Reset</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
