@extends('layouts.app')
@section('content')
    <div id="main">
        <header class="mb-3">
            <a href="#" class="burger-btn d-block d-xl-none">
                <i class="bi bi-justify fs-3"></i>
            </a>
        </header>

        <div class="page-heading">
            <div class="page-title">
                <div class="row">
                    <div class="col-12 col-md-6 order-md-1 order-last">
                        <h3>Payments</h3>
                        <p class="text-subtitle text-muted"></p>
                    </div>
                    <div class="col-12 col-md-6 order-md-2 order-first">
                        <nav aria-label="breadcrumb" class="breadcrumb-header float-start float-lg-end">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{url('dashboard')}}">Dashboard</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Payments</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
             @if(session('success'))
                <div class="alert alert-success"><i class="bi bi-check-circle"></i> {{ session('success') }}</div>
            @endif
            @if(session('error'))
                <div class="alert alert-danger"><i class="bi bi-exclamation-triangle"></i>
                    {{ session('error') }}
                </div>
            @endif
            <section class="section">
                <div class="card">
                    <div class="card-header">
                        All Payments
                        @if(Auth::user()->role == 1)
                        <a href="{{url('payments/new')}}" class="btn btn-primary pull-right"><i class="fa fa-plus" aria-hidden="true"></i>
                            New Payment</a>
                            @endif
                    </div>
                    <div class="card-body">
                        <table class="table table-striped" id="table1">
                            <thead>
                            <tr>
                                 @if(Auth::user()->role ==1 )
                                <th>Customer</th>
                                <th>Phone</th>
                                @endif
                                <th>Receipt Number</th>
                                <th>Amount</th>
                                <th>Status</th>
                                <th>Payment Date</th>
                                  @if(Auth::user()->role ==1 )
                                <th>Actions</th>
                                @endif
                            </tr>
                            </thead>
                            <tbody>
                                @foreach($payments  as $pay)
                            <tr>
                                @php
                                $p = App\Models\User::where('phone', $pay->phone)->first();

                                @endphp
                                @if(Auth::user()->role ==1 )
                                <td>{{$p->name}}</td>
                                <td>{{$pay->phone}}</td>
                                @endif
                                <td>{{$pay->receipt_number}}</td>
                                <td>Khs {{$pay->amount}}</td>
                                @if($pay->trashed())
                                <td>
                                    <span class="badge bg-danger">Voided</span>
                                </td>
                                @else
                                 <td>
                                    <span class="badge bg-success">Processed</span>
                                </td>
                                @endif
                                @php
                                    $inputDateTime = $pay->created_at;
                                $datep = Illuminate\Support\Carbon::parse($inputDateTime);
                                $days_ = $datep->longAbsoluteDiffForHumans(Illuminate\Support\Carbon::now());
                                $daysAgo = $days_;

                                @endphp
                                <td>{{$daysAgo}}</td>
                                  @if(Auth::user()->role ==1 )

                                <td>
                                    <div class="btn-group mb-1">
                                        <div class="dropdown">
                                            <button class="btn btn-secondary btn-sm dropdown-toggle me-1" type="button"
                                                    id="dropdownMenuButtonSec" data-bs-toggle="dropdown"
                                                    aria-haspopup="true" aria-expanded="false">
                                                Actions
                                            </button>
                                            <div class="dropdown-menu" style="min-width:10px !important;" aria-labelledby="dropdownMenuButtonSec">

                                                <a class="dropdown-item" href="{{url('payment/void',$pay->id)}}"><i class="fa fa-trash" aria-hidden="true" style="color: #7c8db5;"></i> Void</a>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                                @endif
                            </tr>
                            @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>

            </section>
        </div>

@endsection
