@extends('layouts.app')
@section('content')
    <div id="main">
        <header class="mb-3">
            <a href="#" class="burger-btn d-block d-xl-none">
                <i class="bi bi-justify fs-3"></i>
            </a>
        </header>

        <div class="page-heading">
            <div class="page-title">
                <div class="row">
                    <div class="col-12 col-md-6 order-md-1 order-last">
                        <h3>Payments</h3>
                        <p class="text-subtitle text-muted"></p>
                    </div>
                    <div class="col-12 col-md-6 order-md-2 order-first">
                        <nav aria-label="breadcrumb" class="breadcrumb-header float-start float-lg-end">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{url('dashboard')}}">Dashboard</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Edit Payment</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>



        </div>
        <div class="alert alert-warning"><i class="bi bi-exclamation-triangle"></i> Before adding / updating payments, ensure the user has a phone number in their profile.</div>
        <section id="multiple-column-form">
            <div class="row match-height">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Edit Payment</h4>
                            <a onclick="history.back()" class="btn btn-primary pull-right"><i class="fa fa-arrow-left" aria-hidden="true"></i>
                                Back</a>
                        </div>
                        <div class="card-content">
                            <div class="card-body">
                                <form class="form" method="post" action="{{url('payments/update',$payment->id)}}">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="first-name-column">Customer</label>
                                                <select class="choices form-select  @error('customer') is-invalid @enderror" name="customer">

                                                    @foreach($customers as $customer)
                                                        <option value="{{$customer->phone}} @if($customer->phone == $payment->phone) selected @endif">{{$customer->name}}</option>
                                                    @endforeach

                                                </select>
                                                @error('customer')
                                                <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="last-name-column">Receipt Number</label>
                                                <input type="text" id="last-name-column" class="form-control @error('receipt_number') is-invalid @enderror"
                                                       placeholder="Receipt Number" name="receipt_number" value="{{$payment->receipt_number}}">

                                                @error('receipt_number')
                                                <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="city-column">Amount</label>
                                                <input type="text" id="city-column" class="form-control  @error('amount') is-invalid @enderror"
                                                       placeholder="amount" name="amount" value="{{$payment->amount}}">
                                                @error('amount')
                                                <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="country-floating">Payment Method</label>
                                                <select class="choices form-select @error('channel') is-invalid @enderror" name="channel">
                                                    <option value="">Select Payment Method</option>
                                                    <option value="bank">Bank</option>
                                                    <option value="mpesa">Mpesa</option>
                                                    <option value="cash">Cash</option>

                                                </select>
                                                @error('channel')
                                                <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="company-column">Status</label>
                                                <select class="choices form-select @error('status') is-invalid @enderror" name="channel" name="status">
                                                    <option value="1">Processed</option>
                                                    <option value="0">Pending</option>

                                                </select>
                                                @error('status')
                                                <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                                @enderror
                                            </div>
                                        </div>


                                        <div class="col-12 d-flex justify-content-end">
                                            <button type="submit"
                                                    class="btn btn-primary me-1 mb-1">Submit</button>
                                            <button type="reset"
                                                    class="btn btn-light-secondary me-1 mb-1">Reset</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
