@extends('layouts.app')
@section('content')
    <div id="main">
        <header class="mb-3">
            <a href="#" class="burger-btn d-block d-xl-none">
                <i class="bi bi-justify fs-3"></i>
            </a>
        </header>

        <div class="page-heading">
            <div class="page-title">
                <div class="row">
                    <div class="col-12 col-md-6 order-md-1 order-last">
                        <h3>Invoices</h3>
                        <p class="text-subtitle text-muted"></p>
                    </div>
                    <div class="col-12 col-md-6 order-md-2 order-first">
                        <nav aria-label="breadcrumb" class="breadcrumb-header float-start float-lg-end">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{url('dashboard')}}">Dashboard</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Invoices</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
            @if(session('success'))
                <div class="alert alert-success"><i class="bi bi-check-circle"></i> {{ session('success') }}</div>
            @endif
            @if(session('error'))
                <div class="alert alert-danger"><i class="bi bi-exclamation-triangle"></i>
                    {{ session('error') }}
                </div>
            @endif
            <section class="section">
                <div class="card">
                    <div class="card-header">
                        All Invoices

                    </div>
                    <div class="card-body">
                        <table class="table table-striped" id="table1">
                            <thead>
                            <tr>
                                    <th>Customer</th>
                                    <th>Phone</th>
                                <th>Package</th>
                                <th>Amount</th>
                                <th>Location</th>
                                <th>Subscription Date</th>
                                    <th>Actions</th>

                            </tr>
                            </thead>
                            <tbody>
                            @foreach($subscriptions  as $pay)
                                <tr>
                                    @php
                                        $p = App\Models\User::where('phone', $pay->username)->first();
                                        $pac = App\Models\Package::where('id',$pay->package)->first();

                                    @endphp

                                        <td>{{$p->name}}</td>
                                        <td>{{$p->phone}}</td>
                                    <td>{{$pac->name}}</td>
                                    <td>{{$pac->price}}</td>

                                    <td>{{$pay->location}}</td>
                                    <td>{{$pay->end_date}}</td>
                                        <td>
                                            <div class="btn-group mb-1">
                                                <div class="dropdown">
                                                    <button class="btn btn-secondary btn-sm dropdown-toggle me-1" type="button"
                                                            id="dropdownMenuButtonSec" data-bs-toggle="dropdown"
                                                            aria-haspopup="true" aria-expanded="false">
                                                        Actions
                                                    </button>
                                                    <div class="dropdown-menu" style="min-width:10px !important;" aria-labelledby="dropdownMenuButtonSec">

                                                        <a class="dropdown-item" href="{{url('invoice/message',$pay->id)}}"><i class="fa-envelope-o" aria-hidden="true" style="color: #7c8db5;"></i> Send  message</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>

                                </tr>
                            @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>

            </section>
        </div>

@endsection
