@extends('layouts.app')
@section('content')
    <div id="main">
        <header class="mb-3">
            <a href="#" class="burger-btn d-block d-xl-none">
                <i class="bi bi-justify fs-3"></i>
            </a>
        </header>
        @if(session('success'))
            <div class="alert alert-success"><i class="bi bi-check-circle"></i> {{ session('success') }}</div>
        @endif
        @if(session('error'))
            <div class="alert alert-danger"><i class="bi bi-check-circle"></i>
                {{ session('error') }}
            </div>
        @endif

        <div class="page-heading">
            <div class="page-title">
                <div class="row">
                    <div class="col-12 col-md-6 order-md-1 order-last">
                        <h3>New Package</h3>
                        <p class="text-subtitle text-muted"></p>
                    </div>
                    <div class="col-12 col-md-6 order-md-2 order-first">
                        <nav aria-label="breadcrumb" class="breadcrumb-header float-start float-lg-end">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{url('dashboard')}}">Dashboard</a></li>
                                <li class="breadcrumb-item active" aria-current="page">New Package</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>



        </div>
        <section id="multiple-column-form">
            <div class="row match-height">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Create Package</h4>
                            <a onclick="history.back()" class="btn btn-primary pull-right"><i class="fa fa-arrow-left" aria-hidden="true"></i>
                                Back</a>
                        </div>
                        <div class="card-content">
                            <div class="card-body">
                                <form class="form" method="POST" action="{{url('package/store')}}">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="first-name-column">Package Name</label>
                                                <input type="text" id="first-name-column" class="form-control  @error('name') is-invalid @enderror"
                                                       placeholder="Package Name" name="name" value="{{ old('name') }}">
                                                @error('name')
                                                <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="last-name-column">Type Of Package</label>
                                                <select class="choices form-select  @error('type') is-invalid @enderror" name="type">
                                                    <option value="">Select Type</option>
                                                    <option value="hotspot">Hotspot</option>
                                                    <option value="ppoe">PPOE</option>
                                                </select>
                                                @error('type')
                                                <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="city-column">Size (MB)</label>
                                                <input type="number" id="city-column" class="form-control  @error('size') is-invalid @enderror"
                                                       placeholder="Enter Size" name="size" value="{{ old('size') }}">
                                                @error('size')
                                                <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="city-column">Price </label>
                                                <input type="number" id="city-column" class="form-control  @error('price') is-invalid @enderror"
                                                       placeholder="Enter Price" name="price" value="{{ old('price') }}">
                                                @error('price')
                                                <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="country-floating">Upload Speed</label>
                                                <input type="number" id="country-floating" class="form-control  @error('upload_speed') is-invalid @enderror"
                                                       name="upload_speed" placeholder="Upload Speed" value="{{ old('upload_speed') }}">
                                                @error('upload_speed')
                                                <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="country-floating">Download Speed</label>
                                                <input type="number" id="country-floating" class="form-control  @error('download_speed') is-invalid @enderror"
                                                       name="download_speed" placeholder="Download Speed" value="{{ old('download_speed') }}">
                                                @error('download_speed')
                                                <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="company-column">Duration Unit</label>
                                                <select class="choices form-select  @error('unit') is-invalid @enderror" name="unit">
                                                    <option value="">Select Unit</option>
                                                    <option value="Minutes">Minutes</option>
                                                    <option value="Hours">Hours</option>
                                                    <option value="Days">Days</option>
                                                    <option value="Months">Months</option>

                                                </select>
                                                @error('unit')
                                                <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="country-floating">Time</label>
                                                <input type="number" id="country-floating" class="form-control  @error('time') is-invalid @enderror"
                                                       name="time" placeholder="Time" value="{{ old('time') }}">
                                                @error('time')
                                                <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="country-floating">Devices</label>
                                                <input type="number" id="country-floating" class="form-control  @error('time') is-invalid @enderror"
                                                       name="devices" placeholder="Devices" value="{{ old('devices') }}">
                                                @error('devices')
                                                <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="country-floating">Description</label>
                                                <textarea class="form-control  @error('description') is-invalid @enderror"  name="description" placeholder="Description">{{ old('description') }}</textarea> 
                                                  
                                                @error('description')
                                                <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                                @enderror
                                            </div>
                                        </div>



                                        <div class="col-12 d-flex justify-content-end">
                                            <button type="submit"
                                                    class="btn btn-primary me-1 mb-1">Submit</button>
                                            <button type="reset"
                                                    class="btn btn-light-secondary me-1 mb-1">Reset</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
