@extends('layouts.app')
@section('content')
    <div id="main">
        <header class="mb-3">
            <a href="#" class="burger-btn d-block d-xl-none">
                <i class="bi bi-justify fs-3"></i>
            </a>
        </header>

        <div class="page-heading">
            <div class="page-title">
                <div class="row">
                    <div class="col-12 col-md-6 order-md-1 order-last">
                        <h3>Expenses</h3>
                        <p class="text-subtitle text-muted"></p>
                    </div>
                    <div class="col-12 col-md-6 order-md-2 order-first">
                        <nav aria-label="breadcrumb" class="breadcrumb-header float-start float-lg-end">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{url('dashboard')}}">Dashboard</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Expenses</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
           @if(session('success'))
                <div class="alert alert-success"><i class="bi bi-check-circle"></i> {{ session('success') }}</div>
            @endif
            @if(session('error'))
                <div class="alert alert-danger"><i class="bi bi-exclamation-triangle"></i>
                    {{ session('error') }}
                </div>
            @endif
            <section class="section">
                <div class="card">
                    <div class="card-header">
                       All Expenses
                       <a href="{{url('admin/expense/create')}}" class="btn btn-primary pull-right"><i class="fa fa-plus" aria-hidden="true"></i>
                            New Expense</a>
                    </div>

                    <div class="card-body">
                         <table class="table table-striped" id="table1">
                <thead>
                  <tr>
                    <th>#</th>
                    <th>Amount</th>
                    <th>Date</th>
                     <th>Description</th>
                      <th>Added By</th>
                      @if(Auth::user()->role == 1)
                    <th>Actions</th>
                    @endif
                   
                  </tr>
                </thead>
                <tbody>
                  @foreach($expenses as $expense)
                  <tr>
                    <th scope="row">{{ $loop->iteration }}</th>
                    <td>{{number_format($expense->amount,2)}} Ksh</td>
                   <td>{{$expense->date}}</td>
                   <td>{{$expense->description}}</td>
                   @php
                   $user = App\Models\User::where('id', $expense->user_id)->first();

                   @endphp
                    <td>{{$user->name}}</td>

                   
                  @if(Auth::user()->role == 1)
                    


                      <td>
                                    <div class="btn-group mb-1">
                                        <div class="dropdown">
                                            <button class="btn btn-secondary btn-sm dropdown-toggle me-1" type="button"
                                                    id="dropdownMenuButtonSec" data-bs-toggle="dropdown"
                                                    aria-haspopup="true" aria-expanded="false">
                                                Actions
                                            </button>
                                            <div class="dropdown-menu" style="min-width:10px !important;" aria-labelledby="dropdownMenuButtonSec">

                                                    <a class="dropdown-item" href="{{url('admin/expense/edit',$expense->id)}}"><i class="fa fa-pencil-square-o" aria-hidden="true" style="color: #7c8db5;"></i>
                                                         Edit</a>
                                                          <a class="dropdown-item" href="{{url('admin/expense/delete',$expense->id)}}"><i class="fa fa-trash" aria-hidden="true" style="color: #7c8db5;"></i>
                                                         Delete</a>
                                                
                                            </div>
                                        </div>
                                    </div>
                                </td>
                      
                         
                    @endif
                  </tr>


                  @endforeach
                
                </tbody>
              </table>
                    </div>
                </div>

            </section>
        </div>

@endsection
