<?php

namespace App\Http\Controllers;

use App\Models\Package;
use App\Models\User;
use App\Models\Region;
use App\Traits\Common;
use Illuminate\Http\Request;
use RouterOS\Client;
use RouterOS\Config;
use RouterOS\Query;
use Auth;
use Hash;
class UsersController extends Controller
{
    use Common;
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        //
         if ($request->filled('status')) {

             // $users = User::where('status',1)->where('role',2)->orderBy('created_at', 'DESC')->get();
              $users =User::join('subscriptions', 'users.id', '=', 'subscriptions.user_id')
                    ->where('users.status', '=', 1)
                    ->where('subscriptions.status', '=', 1)
                    ->get();

              return view('admin.users.index', compact('users'));

             

         }else{
              $users = User::orderBy('created_at', 'DESC')->get();
             return view('admin.users.index', compact('users'));
         }
      

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $user = User::where('id',$id)->first();
        $connect = $this->connect();
        $config = new Config([
            'host' => $connect['host'] ,
            'user' => $connect['username'],
            'pass' => $connect['password'],
            'port' => $connect['port'],
        ]);

        $client2 = new Client($config);

        $query = (new Query('/ppp/secret/print'))
            ->where('name', '0708684336');
        $secret = $client2->q($query)->read();
       // dd($secret);

        if(!$user)
        {
            return redirect()->back()->with('error', 'User not found');
        }
        return view('admin.users.view',compact('user','secret'));

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function supportTeam()
    {
        $users = User::where('role',3)->orderBy('created_at','DESC')->get();
        return view('admin.employees.index',compact('users'));
    }

    public function storeTeam(Request $request)
    {

        $userData =  $request->validate([
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'phone' => ['required', 'string', 'unique:users'],
            'password' => ['required','min:4'],
            'region' => ['required']
        ]);

        $user = new User;
        $user->name = $request->input('name');
         $user->email = $request->input('email');
          $user->phone = $request->input('phone');
           $user->password = $request->input('password');
            $user->region = $request->input('region');
            $user->role = 3;

        $ok = $user->save();
        $route = URL('/admin/team/support');
        if($ok)
        {
            return redirect($route)->with('success','Support User created successfully');

        }else{
            return redirect($route)->with('error','something went wrong');

        }

    }

    public function createTeam()
    {
        $regions = Region::orderBy('name','ASC')->get();
        return view('admin.employees.create',compact('regions'));
    }


    public function editTeam($id)
    {
        $user = User::where('id',$id)->first();
        $regions = Region::orderBy('name','ASC')->get();

        return view('admin.employees.edit',compact('user','regions'));
    }

    public function updateTeam($id,Request $request)
    {


        $userData =  $request->validate([
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string'],
            'phone' => ['required', 'string'],
            'password' => ['required','min:4'],
            'region' => ['required']
        ]);

        $ok = User::where('id',$id)->update([
            'name' => $request->input('name'),
            'email' => $request->input('email'),
            'phone' => $request->input('phone'),
            'password' => $request->input('password'),
            'region' => $request->input('region'),

        ]);


        $route = URL('/admin/team/support');
        if($ok)
        {
            return redirect($route)->with('success','Support team updated successfully');

        }else{
            return redirect($route)->with('error','something went wrong');

        }



    }

    public function deleteTeam($id)
    {
        $user = User::where('id',$id)->first();

        $ok = $user->delete();

        $route = URL('/admin/team/support');
        if($ok)
        {
            return redirect($route)->with('success','Support team deleted successfully');

        }else{
            return redirect($route)->with('error','something went wrong');

        }

    }

    
    public function editProfile()
    {
        $user = User::where('id', Auth::user()->id)->first();

        return view('admin.profile.edit',compact('user'));

    }

    public function postProfile(Request $request)
    {

        $userData =  $request->validate([
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string'],
            'phone' => ['required', 'string'],
            'password' => ['required','min:4'],
    

        ]);
        $name = $request->name;
        $email = $request->email;
        $password = $request->password;
        $id = $request->id;
        
           $user = User::where('id',$id)->update([
            'name' => $name,
            'email' => $email,
            'password' => Hash::make($password),
        ]);

           $route = URL('/dashboard');
        if($user)
        {
            return redirect($route)->with('success','Details Updated Successfully');

        }else{
            return redirect($route)->with('error','something went wrong');

        }




    }



}
