<?php

namespace App\Http\Controllers;

use App\Models\Region;
use App\Models\Ticket;
use Illuminate\Http\Request;
use App\Models\Message;
use App\Models\User;
use URL;

class SmsController extends Controller
{
    //
    public function __construct()
    {
        $this->middleware('auth');
    }
    public function index()
    {
        $messages = Message::orderBy('created_at', 'DESC')->paginate(10);
        return view('admin.sms.index', compact('messages'));
    }
    public function create(){
        $users = User::orderBy('name','ASC')->get();
        $region = Region::orderBy('name','ASC')->get();
        return view('admin.sms.create',compact('users','region'));
    }

    public function createSmsTicket($id){
        $ticket = Ticket::where('id',$id)->first();

        $users = User::orderBy('name','ASC')->get();
        $region = Region::orderBy('name','ASC')->get();
        return view('admin.sms.ticket_sms',compact('users','region','id'));
    }

    public function store(Request $request)
    {
        $route = 'sms.index';
        $smsData =  $request->validate([
            'user' => 'required',
            'message' => 'required',
         ]);
        if($smsData['user'] != 'all')
        {
            $u = User::where('id', $request->user)->first();
            //send sms
            $sm = new Message;
            $send = $sm->sendSms($u->phone,$request->message);

        }else{

            $users = User::all();
            foreach($users as $user)
            {
                $sm = new Message;
                $send = $sm->sendSms($user->phone,$request->message);
            }

        }
        if($send == 0)
        {
             return redirect()->route($route)->with('error', 'Something went wrong');
        }
        if($send)
        {
             return redirect()->route($route)->with('success', 'Message sent successfully');




        }else{
            return redirect()->route($route)->with('error', 'Something went wrong');

        }
    }

    public function storeRegion(Request $request)
    {
        $smsData =  $request->validate([
            'region' => 'required',
            'message' => 'required',
        ]);
        if($smsData['region'] != 'all')
        {
            $users = User::where('region', $request->region)->get();
            foreach($users as $user)
            {
                //send sms
                $sm = new Message;
                $send = $sm->sendSms($user->phone,$request->message);
            }


        }else{

            $users = User::all();
            foreach($users as $user)
            {
                $sm = new Message;
                $send = $sm->sendSms($user->phone,$request->message);
            }

        }
        if($send)
        {

            return redirect()->back()->with('success', 'Message sent successfully');
        }else{
            return redirect()->back()->with('error', 'Something went wrong');

        }
    }

    public function storeSmsTicket(Request $request,$id)
    {
        $route = 'tickets.index';
        $smsData =  $request->validate([

            'message' => 'required',
        ]);

            $user = User::where('id',$id)->first();

            $sm = new Message;
            $send = $sm->sendSms($user->phone,$request->message);


        if($send == 0)
        {
            return redirect()->route($route)->with('error', 'Something went wrong');
        }
        if($send)
        {
            return redirect()->route($route)->with('success', 'Message sent successfully');




        }else{
            return redirect()->route($route)->with('error', 'Something went wrong');

        }
    }



    public function delete($id)
    {
        $sms = Message::where('id', $id)->first();
        if(!$sms)
        {
            return redirect()->back()->with('error', 'Sms not found');

        }else{
            $sms->delete();
            return redirect()->back()->with('success', 'Message deleted successfully');

        }

    }


}


