<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Setting;

class SettingsController extends Controller
{
    //

    public function index()
    {
    	$setting = Setting::where('status',1)->first();

    	return view('admin.settings.index', compact('setting'));
    }

    public function store(Request $request)
    {

    	 $settingsData =  $request->validate([
            'mikrotik_user' => 'required',
           // 'mikrotik_password' => 'required',
            'mikrotik_host' => 'required',
            'mpesa_consumerkey' => 'required',
             'mpesa_consumerkey' => 'required',
             'mpesa_consumersecret' => 'required',
              'mpesa_passkey' => 'required',
             'mpesa_initiator_password' => 'required',
             'mpesa_shortcode' => 'required',
             'mpesa_initiator_username' => 'required',
              'sms_username' => 'required',
              // 'sms_shortcode' => 'required',
               'sms_apikey' => 'required',
        ]);

       $data = [

             'mikrotik_user' => $request->input('mikrotik_user'),
             'mikrotik_password' => $request->input('mikrotik_password'),
             'mikrotik_host' => $request->input('mikrotik_host'),
             'mpesa_consumerkey' => $request->input('mpesa_consumerkey'),
             'mpesa_consumersecret' => $request->input('mpesa_consumersecret'),
             'mpesa_passkey' => $request->input('mpesa_passkey'),
             'mpesa_initiator_password' => $request->input('mpesa_initiator_password'),
             'mpesa_shortcode' => $request->input('mpesa_shortcode'),
             'sms_username' => $request->input('sms_username'),
             'sms_apikey' => $request->input('sms_apikey'),
             'sms_shortcode' => $request->input('sms_shortcode'),
        ];

    	
    	 $ok = Setting::where('status', 1)->update($data);

    	 if($ok)
    	 {
    	 	return redirect()->back()->with('success', 'Settings updated successfully');
    	 }else{
    	 	    	 	return redirect()->back()->with('error', 'Failed something went wrong');

    	 }



    }
}
