<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Expense;
use App\Models\Subscription;
use App\Models\Region;
use Redirect;
use URL;

class ReportsController extends Controller
{
     public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
    	$regions = Region::orderBy('name','ASC')->get();
    	$today = now()->format('Y-m-d');

        if($request->has('region')){

        	$userRegionId = $request['region'];;

		
			$subscriptions = Subscription::whereDate('subscriptions.created_at', '=', $today)->orderBy('subscriptions.created_at', 'desc')->join('users', 'subscriptions.user_id', '=', 'users.id')
			    ->where('users.region', '=', $userRegionId)
			    ->get();

			 $total = Subscription::whereDate('subscriptions.created_at', '=', $today)->orderBy('subscriptions.created_at', 'desc')->join('users', 'subscriptions.user_id', '=', 'users.id')
			    ->where('users.region', '=', $userRegionId)
			    ->sum('amount');

	        return view('admin.reports.daily', compact('subscriptions','total','regions'));
        }else{

	        $subscriptions =  Subscription::whereDate('created_at', $today)->orderBy('created_at', 'desc')->get();
	        $total = Subscription::whereDate('created_at', $today)->sum('amount');

	        return view('admin.reports.daily', compact('subscriptions','total','regions'));
        }
        
    }
     public function weeklyReport(Request $request)
    {

    	$startOfWeek = now()->startOfWeek(); // Get the start of the week
		$endOfWeek = now()->endOfWeek();
		$regions = Region::orderBy('name', 'ASC')->get();

		if ($request->has('region')) {
		    $userRegionId = $request->input('region');

		    $subscriptions = Subscription::whereBetween('subscriptions.created_at', [$startOfWeek, $endOfWeek]) // Use whereBetween for date range
		        ->orderBy('subscriptions.created_at', 'desc')
		        ->join('users', 'subscriptions.user_id', '=', 'users.id')
		        ->where('users.region', '=', $userRegionId)
		        ->get();



			 $total = Subscription::whereBetween('subscriptions.created_at', [$startOfWeek, $endOfWeek])->orderBy('subscriptions.created_at', 'desc')->join('users', 'subscriptions.user_id', '=', 'users.id')
			    ->where('users.region', '=', $userRegionId)
			    ->sum('amount');

	        return view('admin.reports.weekly', compact('subscriptions','total','regions'));
        }else{

	         $subscriptions =  Subscription::whereBetween('created_at', [$startOfWeek, $endOfWeek])->orderBy('created_at', 'desc')->get();
	        $total = Subscription::where('status',1)->whereBetween('created_at', [$startOfWeek, $endOfWeek])->sum('amount');


	        return view('admin.reports.weekly', compact('subscriptions','total','regions'));
        }
       
    }
    public function monthlyReport(Request $request)
    {
    	 $currentMonth = date('Y-m');
    	 $regions = Region::orderBy('name', 'ASC')->get();


    	if ($request->has('region')) {
		    $userRegionId = $request->input('region');

		    $subscriptions = Subscription::whereYear('subscriptions.created_at', now()->year)
		        ->whereMonth('subscriptions.created_at', now()->month)
		        ->orderBy('subscriptions.created_at', 'desc')
		        ->join('users', 'subscriptions.user_id', '=', 'users.id')
		        ->where('users.region', '=', $userRegionId)
		        ->get();


			 $total = Subscription::whereYear('subscriptions.created_at', now()->year)
		        ->whereMonth('subscriptions.created_at', now()->month)
		        ->orderBy('subscriptions.created_at', 'desc')
		        ->join('users', 'subscriptions.user_id', '=', 'users.id')
		        ->where('users.region', '=', $userRegionId)
		        ->sum('amount');

	        return view('admin.reports.monthly', compact('subscriptions','total','regions'));
        }else{

	        $subscriptions =  Subscription::whereRaw("DATE_FORMAT(created_at, '%Y-%m') = ?", [$currentMonth])->orderBy('created_at', 'desc')->get();
            $total = Subscription::whereRaw("DATE_FORMAT(created_at, '%Y-%m') = ?", [$currentMonth])->sum('amount');


	        return view('admin.reports.monthly', compact('subscriptions','total','regions'));
        }


   
    }

    public function customReport(Request $request)
    {
        $startDate = $request['from'];
        $endDate = $request['to'];
        $from = $startDate;
        $to = $endDate;

         $regions = Region::orderBy('name', 'ASC')->get();


        if ($request->filled('region')) {
		    $userRegionId = $request->input('region');

		    $subscriptions = Subscription::whereBetween('subscriptions.created_at', [$startDate, $endDate])
		        ->orderBy('subscriptions.created_at', 'desc') // Specify the table for ordering
		        ->join('users', 'subscriptions.user_id', '=', 'users.id')
		        ->where('users.region', '=', $userRegionId)
		        ->get();


			$total = Subscription::whereBetween('subscriptions.created_at', [$startDate, $endDate])
		        ->orderBy('subscriptions.created_at', 'desc') // Specify the table for ordering
		        ->join('users', 'subscriptions.user_id', '=', 'users.id')
		        ->where('users.region', '=', $userRegionId)
		        ->sum('amount');

	        return view('admin.reports.custom', compact('subscriptions','total','regions','from','to'));
        }else{

	         $subscriptions =  Subscription::whereBetween('created_at', [$startDate, $endDate])->orderBy('created_at', 'desc')->get();
	      // dd($subscriptions);
	        $total = Subscription::whereBetween('created_at', [$startDate, $endDate])->sum('amount');


	        return view('admin.reports.custom', compact('subscriptions','total','regions','from','to'));
        }
    }

    public function todayExpense()
    {
        $today = now()->format('Y-m-d');
        $expenses =  Expense::whereDate('created_at', $today)->orderBy('created_at', 'desc')->get();
        $total = Expense::whereDate('created_at', $today)->sum('amount');

        return view('admin.reports.today_expense', compact('expenses','total'));
    }
    public function weeklyExpense()
    {
         $startOfWeek = now()->startOfWeek(); // Get the start of the week
        $endOfWeek = now()->endOfWeek(); // Get the end of the week

        $expenses =  Expense::whereBetween('created_at', [$startOfWeek, $endOfWeek])->orderBy('created_at', 'desc')->get();
        $total = Expense::whereBetween('created_at', [$startOfWeek, $endOfWeek])->sum('amount');

        return view('admin.reports.week_expense', compact('expenses','total'));
    }
    public function monthlyExpense()
    {
         $currentMonth = date('Y-m'); // Get the current month in the format 'YYYY-MM'
          $expenses =  Expense::whereRaw("DATE_FORMAT(created_at, '%Y-%m') = ?", [$currentMonth])->orderBy('created_at', 'desc')->get();
        $total = Expense::whereRaw("DATE_FORMAT(created_at, '%Y-%m') = ?", [$currentMonth])->sum('amount');

        return view('admin.reports.month_expense', compact('expenses','total'));
    }

    public function customExpenseReport(Request $request)
    {
        //
        $startDate = $request['from'];
        $endDate = $request['to'];
        $from = $startDate;
        $to = $endDate;

       $expenses =  Expense::whereBetween('date', [$startDate, $endDate])->orderBy('created_at', 'desc')->get();
        $total = Expense::whereBetween('date', [$startDate, $endDate])->sum('amount');

        return view('admin.reports.custom_expense', compact('expenses','total','from','to'));
    }

    public function profitReport(Request $request)
    {
        $startDate = $request['from'];
        $endDate = $request['to'];
        $from = $startDate;
        $to = $endDate;

        //$expenses =  Expense::whereBetween('date', [$startDate, $endDate])->orderBy('created_at', 'desc')->get();

        $total_expenses = Expense::whereBetween('created_at', [$startDate, $endDate])->sum('amount');
        $total_sales = Subscription::whereBetween('created_at', [$startDate, $endDate])->sum('amount');

       

        $total_profit = $total_sales - $total_expenses;


        return view('admin.reports.custom_profit', compact('total_expenses','total_sales','total_profit','from','to'));

    }




    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
