<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use App\Models\Payment;
use Auth;
use App\Models\Message;

class PaymentsController extends Controller
{
    //
    public function __construct()
    {
        $this->middleware('auth');
    }
    public function index()
    {
        if(Auth::user()->role == 1){
            $payments = Payment::orderBy('created_at', 'DESC')->withTrashed()->paginate(10);
        }else{
            $payments = Payment::where('phone', Auth::user()->phone)->withTrashed()->orderBy('created_at', 'DESC')->paginate(10);

        }



        return view('admin.payments.index', compact('payments'));
    }
    public function create()
    {
        $customers = User::orderBy('name','DESC')->get();
        return view('admin.payments.create', compact('customers'));


    }
    public function edit($id)
    {
        $customers = User::orderBy('name','DESC')->get();
        $payment = Payment::where('id', $id)->first();
        return view('admin.payments.edit', compact('customers', 'payment'));


    }

    public function store(Request $request)
    {
        $userData =  $request->validate([
            'customer' => ['required', 'string', 'max:255'],
            'receipt_number' => ['required','unique:payments'],
            'channel' => ['required'],
            'amount' => ['required','min:4'],
            'status' => ['required']
        ]);
        $user = User::where('phone', $request->customer)->first();

        $payment = new Payment;
        $payment->phone = $user->phone;
        $payment->receipt_number = $request->receipt_number;
        $payment->type = $request->channel;
        $payment->amount = $request->amount;
        $payment->status = $request->status;

        $ok = $payment->save();
        if($ok)
        {
             $sm = new Message;
            $message = "Thank you $user->name your payment of $request->amount have been received stay connected!";
            $send = $sm->sendSms($user->phone, $message);
            return redirect()->back()->with('success', 'payment added successfully');
        }else{

            return redirect()->back()->with('error', 'something went wrong');

        }
    }
    public function update(Request $request, $id)
    {
        $userData =  $request->validate([
            'customer' => ['required', 'string', 'max:255'],
            'receipt_number' => ['required', 'string', 'email', 'max:255', 'unique:payments'],
            'channel' => ['required', 'string', 'unique:users'],
            'amount' => ['required','min:4'],
            'status' => ['required']
        ]);
        $user = User::where('phone', $request->customer)->first();

        $data = [
            'phone' => $user->phone,
            'receipt_number' => $request->receipt_number,
            'type' => $request->channel,
            'amount' => $request->amount,
            'status' => $request->status,
        ];



        $ok = Payment::where('id',$id)->update($data);
        if($ok)
        {
            return redirect()->back()->with('success', 'payment updated successfully');
        }else{

            return redirect()->back()->with('error', 'something went wrong');

        }
    }

    public function void($id)
    {
         $pay = Payment::where('id',$id)->first();
        if(!$pay)
        {
            return redirect()->back()->with('error', 'payment not found');
        }

        $ok = $pay->delete();

        if($pay)
        {
            return redirect()->back()->with('success', 'payment voided successfully');
        }else{

            return redirect()->back()->with('error', 'something went wrong');

        }

    }
}
