<?php

namespace App\Http\Controllers;

use App\Models\Subscription;
use App\Models\Ticket;
use App\Traits\Common;
use Illuminate\Http\Request;
use App\Models\User;
use PEAR2\Net\RouterOS;
use Carbon\Carbon;
use App\Models\Package;
use Auth;
use RouterOS\Query;
use RouterOS\Config;
use RouterOS\Client;
class DashboardController extends Controller
{
    use Common;

    //
    public function __construct()
    {
        $this->middleware('auth');
    }
    public function index()
    {
        $package = 'Not Subscribed';
        $packets_in = 0;
        $packets_out = 0;
         $packages = Package::all();
         $time_remaining = 'Expired';

        $connect = $this->connect();

       $client = new RouterOS\Client($connect['host'],$connect['username'],$connect['password']);
        $config = new Config([
            'host' => $connect['host'] ,
            'user' => $connect['username'],
            'pass' => $connect['password'],
            'port' => $connect['port'],
        ]);

        $client2 = new Client($config);


        if(Auth::user()->role == 2)
        {

            $phone = Auth::user()->phone;

            $query = (new Query('/ppp/active/print'))
                ->where('name', $phone);
            $profile_response = $client2->q($query)->read();
            if (!empty($profile_response)) {
                $online_status = 'online';
            } else {
                $online_status = 'offline';
            }
            $query = (new Query('/ip/hotspot/user/print'))
            ->where('name', Auth::user()->phone);

           $query2 = (new Query('/ip/hotspot/active/print'))
            ->where('name', Auth::user()->phone);

             $response = $client2->q($query)->read();
             $response2 = $client2->q($query)->read();
             $package_name = '';

             foreach ($response as $resp) {


                $profile = $resp['profile'];
                if($profile == '0MBPS')
                {
                    $package = 'Not Subscribed';
                }else{

                 $query = (new Query('/ip/hotspot/user/profile/print'))
                    ->where('name',$resp['profile']);
                 $profile_response = $client2->q($query)->read();

                     $package = Package::where('name', $profile)->first();
                    $description = $package->description;
                    $time_limit = $package->time;
                    $package_name = $package->name;

                    $time_used = $resp['uptime'];

                    $tm = str_replace("s", "", $time_used);
                    $time_remaining = $time_limit - $tm;


                  foreach ($profile_response as $resp_time) {
                  }

                }


             }

             foreach ($response2 as $resp2) {


                $packets_in = $resp2['packets-in'];
                $packets_out = $resp2['packets-out'];

             }

             try {


            } catch (\Exception $e) {
                return response()->json(['error' => $e->getMessage()]);
            }
                return view('dashboard.index', compact(
                    'packets_in',
                    'packets_out',
                    'package_name',
                    'packages',
                    'time_remaining',
                    'online_status'

                ));
        }


        $packages = Package::all();
    	$users = User::count('id') - 1;

       $request = new RouterOS\Request('/ppp/active/print');
       $response = $client->sendSync($request);
       $totalActiveUsers = count($response);

        $total_earnings = number_format(Subscription::sum('amount'),2);

        $currentMonth = Carbon::now()->format('Y-m');
        $earning_month = number_format(Subscription::whereRaw("DATE_FORMAT(created_at, '%Y-%m') = ?", [$currentMonth])
            ->sum('amount'), 2);

       $request2 = new RouterOS\Request('/ip/neighbor/print');
       $response2 = $client->sendSync($request2);
       $totalRoutersConnected = count($response2);

     $hotspotUsers = $client->sendSync(new RouterOS\Request('/ip/hotspot/user'));

     $totalHotspotUsers = count($hotspotUsers) -1;




      $totalpppoeUsers =$totalActiveUsers;

        $open_tickets = Ticket::where('status',0)->count();

        $query = (new Query('/ppp/active/print'));
        $profile_response = $client2->q($query)->read();
         $onlineUsers = count($profile_response);
        $tickets = Ticket::orderBy('created_at','DESC')->get();



        return view('dashboard.index', compact(
            'users',
            'total_earnings',
            'earning_month',
            'totalRoutersConnected',
            'totalHotspotUsers',
            'totalpppoeUsers',
            'totalActiveUsers',
            'onlineUsers',
            'packages',
            'open_tickets',
            'tickets'
        ));
    }
}
