<?php

namespace App\Console\Commands;

use App\Models\Message;
use App\Models\Subscription;
use Illuminate\Console\Command;

class MessageReminder extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'reminder:message';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Message reminder to user to pay';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $users = Subscription::where('status',1)->whereDate('end_date', '=', Carbon::today()->addDays(3))->get();
        foreach ($users as $user) {
            $sm = new Message;
            $message = "Your plan expires on '.$user->end_date.'make payment to paybill number: 247247  account number: 206206 to avoid interruptions";
            $send = $sm->sendSms($user->username, $message);
        }
    }
}
